/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.core;

import com.mojang.blaze3d.vertex.PoseStack;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.AnimatableProperty;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.CursorStyle;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Insets;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ParentComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.PositionedRectangle;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Positioning;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Size;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Sizing;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.CharTyped;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.FocusGained;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.FocusLost;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.KeyPress;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.MouseDown;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.MouseDrag;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.MouseEnter;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.MouseLeave;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.MouseScroll;
import com.nyfaria.numismaticoverhaul.owostuff.ui.event.MouseUp;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIModel;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIParsing;
import com.nyfaria.numismaticoverhaul.owostuff.ui.util.Drawer;
import com.nyfaria.numismaticoverhaul.owostuff.ui.util.FocusHandler;
import com.nyfaria.numismaticoverhaul.owostuff.util.EventSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public interface ModComponent
extends PositionedRectangle {
    public void draw(PoseStack var1, int var2, int var3, float var4, float var5);

    default public void drawTooltip(PoseStack matrices, int mouseX, int mouseY, float partialTicks, float delta) {
        if (!this.shouldDrawTooltip(mouseX, mouseY)) {
            return;
        }
        Drawer.drawTooltip(matrices, mouseX, mouseY, this.tooltip());
    }

    default public void drawFocusHighlight(PoseStack matrices, int mouseX, int mouseY, float partialTicks, float delta) {
        Drawer.drawRectOutline(matrices, this.x(), this.y(), this.width(), this.height(), -1);
    }

    @Contract(pure=true)
    @Nullable
    public ParentComponent parent();

    @Contract(pure=true)
    @Nullable
    public FocusHandler focusHandler();

    public ModComponent positioning(Positioning var1);

    @Contract(pure=true)
    public AnimatableProperty<Positioning> positioning();

    public ModComponent margins(Insets var1);

    @Contract(pure=true)
    public AnimatableProperty<Insets> margins();

    default public ModComponent sizing(Sizing horizontalSizing, Sizing verticalSizing) {
        this.horizontalSizing(horizontalSizing);
        this.verticalSizing(verticalSizing);
        return this;
    }

    default public ModComponent sizing(Sizing sizing) {
        this.sizing(sizing, sizing);
        return this;
    }

    public ModComponent horizontalSizing(Sizing var1);

    @Contract(pure=true)
    public AnimatableProperty<Sizing> horizontalSizing();

    public ModComponent verticalSizing(Sizing var1);

    @Contract(pure=true)
    public AnimatableProperty<Sizing> verticalSizing();

    public ModComponent id(@Nullable String var1);

    @Nullable
    public String id();

    public ModComponent tooltip(@Nullable List<ClientTooltipComponent> var1);

    default public ModComponent tooltip(@NotNull Collection<Component> tooltip) {
        ArrayList<ClientTooltipComponent> components = new ArrayList<ClientTooltipComponent>();
        for (Component line : tooltip) {
            components.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)line.m_7532_()));
        }
        this.tooltip((List<ClientTooltipComponent>)components);
        return this;
    }

    default public ModComponent tooltip(@NotNull Component tooltip) {
        ArrayList<ClientTooltipComponent> components = new ArrayList<ClientTooltipComponent>();
        for (FormattedCharSequence line : Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)tooltip, Integer.MAX_VALUE)) {
            components.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)line));
        }
        this.tooltip((List<ClientTooltipComponent>)components);
        return this;
    }

    @Contract(pure=true)
    @Nullable
    public List<ClientTooltipComponent> tooltip();

    public ModComponent zIndex(int var1);

    public int zIndex();

    default public boolean shouldDrawTooltip(double mouseX, double mouseY) {
        return this.tooltip() != null && this.isInBoundingBox(mouseX, mouseY);
    }

    public void inflate(Size var1);

    public void mount(ParentComponent var1, int var2, int var3);

    public void dismount(DismountReason var1);

    @Contract(pure=true)
    default public boolean hasParent() {
        return this.parent() != null;
    }

    public boolean onMouseDown(double var1, double var3, int var5);

    public EventSource<MouseDown> mouseDown();

    public boolean onMouseUp(double var1, double var3, int var5);

    public EventSource<MouseUp> mouseUp();

    public boolean onMouseScroll(double var1, double var3, double var5);

    public EventSource<MouseScroll> mouseScroll();

    public boolean onMouseDrag(double var1, double var3, double var5, double var7, int var9);

    public EventSource<MouseDrag> mouseDrag();

    public boolean onKeyPress(int var1, int var2, int var3);

    public EventSource<KeyPress> keyPress();

    public boolean onCharTyped(char var1, int var2);

    public EventSource<CharTyped> charTyped();

    default public boolean canFocus(FocusSource source) {
        return false;
    }

    public void onFocusGained(FocusSource var1);

    public EventSource<FocusGained> focusGained();

    public void onFocusLost();

    public EventSource<FocusLost> focusLost();

    public EventSource<MouseEnter> mouseEnter();

    public EventSource<MouseLeave> mouseLeave();

    public CursorStyle cursorStyle();

    public ModComponent cursorStyle(CursorStyle var1);

    default public void update(float delta, int mouseX, int mouseY) {
        this.margins().update(delta);
        this.positioning().update(delta);
        this.horizontalSizing().update(delta);
        this.verticalSizing().update(delta);
    }

    @Override
    default public boolean isInBoundingBox(double x, double y) {
        return PositionedRectangle.super.isInBoundingBox(x, y);
    }

    default public Size fullSize() {
        Insets margins = (Insets)this.margins().get();
        return Size.of(this.width() + margins.horizontal(), this.height() + margins.vertical());
    }

    default public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        if (!element.getAttribute("id").isBlank()) {
            this.id(element.getAttribute("id").strip());
        }
        UIParsing.apply(children, "margins", Insets::parse, this::margins);
        UIParsing.apply(children, "positioning", Positioning::parse, this::positioning);
        UIParsing.apply(children, "z-index", UIParsing::parseSignedInt, this::zIndex);
        UIParsing.apply(children, "cursor-style", UIParsing.parseEnum(CursorStyle.class), this::cursorStyle);
        UIParsing.apply(children, "tooltip-text", UIParsing::parseText, this::tooltip);
        if (children.containsKey("sizing")) {
            Map<String, Element> sizingValues = UIParsing.childElements(children.get("sizing"));
            UIParsing.apply(sizingValues, "vertical", Sizing::parse, this::verticalSizing);
            UIParsing.apply(sizingValues, "horizontal", Sizing::parse, this::horizontalSizing);
        }
    }

    @Override
    @Contract(pure=true)
    public int width();

    @Override
    @Contract(pure=true)
    public int height();

    @Override
    @Contract(pure=true)
    public int x();

    public void setX(int var1);

    @Override
    @Contract(pure=true)
    public int y();

    public void setY(int var1);

    default public void moveTo(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public static enum DismountReason {
        LAYOUT_INFLATION,
        REMOVED;

    }

    public static enum FocusSource {
        MOUSE_CLICK,
        KEYBOARD_CYCLE;

    }
}

